

#ifndef __SARADCKEY_MG04_06_H
#define __SARADCKEY_MG04_06_H

/**
 ******************************************************************************
 *
 * @file        BSP_SARADCKey.h
 * @brief       Scan user press key by ADC.

 * @par         Project
 *              MG32x02z
 * @version     V1.02
 * @date        2022/08/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#include "BSP_Common_MG04_06.h"
#include "MG32x02z_GPIO_DRV.h"


/** 
 * @name  Define 
 */                                                      
///@{

/* Pin*/
#define SARADCKEY_IOM         PINA(0)          /*!< Define ADC channel pin for GPIO initial.*/


/* ADC*/
#define SARADCKEY_ADCCANNEL    ADC_ExtAIN0     /*!< Define ADC channel.*/


/* SARADC conversion result relate define.*/

#define ScanKey_Voltage        3300            /*!< Voltage (3.3V) */ 
#define AllowDiffPressure      26              /*!< ~26 mV */
#define ADCResolution          4095            /*!< 12 bit */

#define SKEY_TOTAL_COMBINATION 4
#define SKEY0_MASK             0x00000001      /*!< SARADC Key0 mask.*/
#define SKEY1_MASK             0x00000002      /*!< SARADC Key1 mask.*/
#define SKEY2_MASK             0x00000004      /*!< SARADC Key2 mask.*/
#define SKEY3_MASK             0x00000008      /*!< SARADC Key3 mask.*/


// Serial Key0 Information control by ADC sample.
 
#define SKey0_Target        1030               /*!< Press SKey0 then ADC will get voltage */ 
#define SKey0_LV            ((SKey0_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey0_HV            ((SKey0_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key1 Information control by ADC sample.
#define SKey1_Target        1650               /*!< Press SKey1 then ADC will get voltage */         
#define SKey1_LV            ((SKey1_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey1_HV            ((SKey1_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key2 Information control by ADC sample. 
#define SKey2_Target        2250               /*!< Press SKey2 then ADC will get voltage */        
#define SKey2_LV            ((SKey2_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey2_HV            ((SKey2_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key3 Information control by ADC sample. 
#define SKey3_Target        2790               /*!< Press SKey3 then ADC will get voltage */         
#define SKey3_LV            ((SKey3_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey3_HV            ((SKey3_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key0 & Key1 Information control by ADC sample.
#define SKey01_Target       79.                /*!< Press SKey0 & SKey1 then ADC will get voltage */ 
#define SKey01_LV           ((SKey01_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey01_HV           ((SKey01_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key0 & Key2 Information control by ADC sample.
#define SKey02_Target       900                /*!< Press SKey0 & SKey2 then ADC will get voltage */
#define SKey02_LV           ((SKey02_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey02_HV           ((SKey02_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key0 & Key3 Information control by ADC sample.
#define SKey03_Target       980                /*!< Press SKey0 & SKey3 then ADC will get voltage */
#define SKey03_LV           ((SKey03_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey03_HV           ((SKey03_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key1 & Key2 Information control by ADC sample.
#define SKey12_Target       1340               /*!< Press SKey1 & SKey2 then ADC will get voltage */
#define SKey12_LV           ((SKey12_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey12_HV           ((SKey12_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key1 & Key3 Information control by ADC sample.
#define SKey13_Target       1510               /*!< Press SKey1 & SKey3 then ADC will get voltage */
#define SKey13_LV           ((SKey13_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey13_HV           ((SKey13_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key2 & Key3 Information control by ADC sample.
#define SKey23_Target       2000               /*!< Press SKey2 & SKey3 then ADC will get voltage */
#define SKey23_LV           ((SKey23_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey23_HV           ((SKey23_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key0 & Key1 & Key2 Information control by ADC sample.
#define SKey012_Target      707                /*!< Press SKey0 & SKey1 & SKey2 then ADC will get voltage */
#define SKey012_LV          ((SKey012_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey012_HV          ((SKey012_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key1 & Key2 & Key3 Information control by ADC sample. 
#define SKey123_Target      1245               /*!< Press SKey1 & SKey2 & SKey3 then ADC will get voltage */
#define SKey123_LV          ((SKey123_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey123_HV          ((SKey123_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key0 & Key2 & Key3 Information control by ADC sample. 
#define SKey023_Target      857                /*!< Press SKey0 & SKey2 & SKey3 then ADC will get voltage */
#define SKey023_LV          ((SKey023_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey023_HV          ((SKey023_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key0 & Key1 & Key3 Information control by ADC sample. 
#define SKey013_Target      753                /*!< Press SKey0 & SKey1 & SKey3 then ADC will get voltage */
#define SKey013_LV          ((SKey013_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey013_HV          ((SKey013_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage

// Serial Key0 & Key1 & Key2 & Key3 Information control by ADC sample.
#define SKey0123_Target     680                /*!< Press SKey0 & SKey1 & SKey2 & SKey3 then ADC will get voltage */
#define SKey0123_LV         ((SKey0123_Target-AllowDiffPressure)*ADCResolution)/ScanKey_Voltage
#define SKey0123_HV         ((SKey0123_Target+AllowDiffPressure)*ADCResolution)/ScanKey_Voltage


///@}

/** 
 * @name  Function  
 */                                                      
///@{

void BSP_SARADCKey_Init(void);
uint32_t BSP_SARADCKey_GetStatus(void);
void BSP_SARADCKey_InitCallback(void);

///@}

#endif
